unit Isamsuch;
{copyright 1995 by Norbert Stellberg GmbH}
interface
    
uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, IsamTabl, Fvcbrows, Isambrow, LowBrows, Filer;

type
  TSuchDlg = class(TForm)
    {the dialog to search for fields in your isamtable,
     don't call this dialog directly, better call it
     with SUCH_EINSTELLEN(...), described later in this file}
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Edit1: TEdit;
    IsamTable1: TIsamTable;
    IsamBrowser1: TIsamBrowser;
    ComboBox1: TComboBox;
    Label2: TLabel;
    function IsamBrowser1BuildRow(Sender: TObject;
      var RR: RowRec): Integer;
    procedure FormShow(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  public
    RecordData: Pointer;
    RecordDup: Pointer;
  end;

var
  SuchDlg: TSuchDlg;

Function Such_Einstellen(Table: TIsamTable; Parent: TForm; var DATA, DUP; var Ref: Longint; var Key: IsamKeyStr;
                         Liste: TStringList): Boolean;
{call this procedure to search for data in the isamtable.
 parameters:
 TABLE: the isamtable, you will search
 PARENT: the form, your will start from
 DATA,DUP: the record, that is stored in your isamtable
 REF: the isamtable's reference-number of the found record
 KEY: the isamtable's key for the found record
 LISTE: stringlist of possible keys

 Example:
procedure T2Dialog.SearchBttnClick(Sender: TObject);
var Ref: Longint;
    Key: IsamKeyStr;
    Liste: TStringList;
begin
  Liste:= TStringList.Create;
  Liste.Add('NAME1');
  Liste.Add('ZIP');
  Liste.Add('NAMES');
  if Such_Einstellen(T2DialogTable,Self,TestRecordData,TestRecordDup,Ref,Key,Liste) then begin
    IsamBrowser1.KeyNumber := T2DialogTable.KeyNo;
    IsamBrowser1.SetAndUpdateBrowserScreen(Key, Ref);
    Key_Speichern(GetAppName,IsamBrowser1.Name,T2DialogTable.KeyNo);
  end;
  Liste.Free;
end;
}
implementation

{$R *.DFM}

Uses UUseIsam, UToolDll;

Function Such_Einstellen(Table: TIsamTable; Parent: TForm; var DATA, DUP; var Ref: Longint; var Key: IsamKeyStr;
                         Liste: TStringList): Boolean;
var Txt: String;
    i: Integer;
    Found: Boolean;
begin
  Ref:= 0;
  Key:= '';
  Result:= False;
  SuchDlg:= TSuchDlg.Create(Parent);
  Try
    if Liste.Count > 0 then begin
      For i:= 0 to Liste.Count-1 do SuchDlg.ComboBox1.Items.Add(Liste[i]);
      SuchDlg.ComboBox1.ItemIndex:= Table.KeyNo - 1;
    end;
    SuchDlg.IsamTable1:= Table;
    GetMem(SuchDlg.RecordData,Table.RecSize);
    GetMem(SuchDlg.RecordDup,Table.RecSize);
    if SuchDlg.ShowModal = mrOk then begin
      SatzLesen(Table.IfbPtr,Table.Ref,Data,Dup);
      Ref:= Table.Ref;
      Key:= Table.Key_Proc(Data,Table.KeyNo);
      Table.Key:= Key;
      KeySuchen(Table.ifbptr,Table.KeyNo,Table.Ref,Key,Found);
      Result:= True;
    end;
  Finally
    FreeMem(SuchDlg.RecordData,Table.RecSize);
    FreeMem(SuchDlg.RecordDup,Table.RecSize);
    SuchDlg.Free;
  end;
end;

function TSuchDlg.IsamBrowser1BuildRow(Sender: TObject;
  var RR: RowRec): Integer;
begin
  Result := NoError;
  Satzlesen(IsamTable1.IfbPtr,RR.Ref,RecordData^,RecordDup^);
  RR.Row:= String_oem2Ansi(IsamTable1.AnsiConvert,
                         IsamTable1.Key_Proc(RecordData^,IsamTable1.KeyNo));
end;

procedure TSuchDlg.FormShow(Sender: TObject);
begin
  IsamBrowser1.ConnectLowBrowser(New(PLowWinBrowser, Init(True, IsamTable1.IFBPTR,
       1, 50, 1, '', '', RecordData^, False )));
  IsamBrowser1.KeyNumber := IsamTable1.KeyNo ;
  Isambrowser1.SetAndUpdateBrowserScreen('',0);
end;

procedure TSuchDlg.Edit1Change(Sender: TObject);
begin
  IsamBrowser1.LowKey:= String_Ansi2Oem(IsamTable1.AnsiConvert,Edit1.Text);
end;

procedure TSuchDlg.OKBtnClick(Sender: TObject);
var Ref: Longint;
begin
  IsamTable1.Ref:= IsamBrowser1.GetCurrentDatRef;
  Satzlesen(IsamTable1.IfbPtr,Ref,RecordData^,RecordDup^);
  ModalResult:= mrOk;
end;

procedure TSuchDlg.ComboBox1Change(Sender: TObject);
begin
  Edit1.Text:= '';
  IsamTable1.KeyNo:= ComboBox1.ItemIndex + 1;
  IsamBrowser1.LowKey:= '';
  IsamBrowser1.KeyNumber := IsamTable1.KeyNo;
  Isambrowser1.SetAndUpdateBrowserScreen('',0);
  Edit1.SetFocus;
end;

procedure TSuchDlg.FormCreate(Sender: TObject);
begin
  if Sprache = 1 then begin
    Caption:= 'Search';
    Label2.Caption:= 'KEY';
    Label1.Caption:= 'search for';
  end;
end;

end.
